//
//  MCGenericPlaceholderView.h
//  MCApplication
//
//  Created by Ali Lalani on 1/11/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCGenericBorderView.h"

@interface MCGenericPlaceholderView : MCGenericBorderView {
	NSAttributedString *attrStr;
	NSString *displayString;
	NSFont *displayFont;
	NSColor *bgColor;
	NSColor *innerBgColor;
	NSColor *textColor;
	NSMutableDictionary *_displayAttributes;

	BOOL roundedBorder;
	BOOL innerRoundedBorder;
	
	unsigned int styleMask;
	float drawingInset;

	id target;
	SEL action;

	NSRect __innerRoundedRect;
	NSRect __displayStringRect;

	NSTrackingRectTag __displayStringTrackingRectTag;
}
- (void)recalculateRects;

// This is set automatically
- (NSAttributedString *)attrStr;
- (void)setAttrStr:(NSAttributedString *)anAttrStr;

- (NSString *)displayString;
- (void)setDisplayString:(NSString *)aDisplayString;

- (NSMutableDictionary *)displayAttributes;
- (void)setDisplayAttributes:(NSMutableDictionary *)attrs;

- (NSFont *)displayFont;
- (void)setDisplayFont:(NSFont *)aFont;

- (NSColor *)bgColor;
- (void)setBgColor:(NSColor *)aBgColor;

- (NSColor *)textColor;
- (void)setTextColor:(NSColor *)aTextColor;

// Unimplemented as of yet...maybe in the future with more styles?
- (unsigned int)styleMask;
- (void)setStyleMask:(unsigned int)aStyleMask;

- (BOOL)roundedBorder;
- (void)setRoundedBorder:(BOOL)flag;

- (NSColor *)innerBgColor;
- (void)setInnerBgColor:(NSColor *)anInnerBgColor;

- (BOOL)innerRoundedBorder;
- (void)setInnerRoundedBorder:(BOOL)flag;

- (void)setDrawingInset:(float)anInset;
- (float)drawingInset;

// TARGET/ACTION
- (id)target;
- (void)setTarget:(id)aTarget;
- (SEL)action;
- (void)setAction:(SEL)anAction;
@end
